import mcculw.ul as mu
import mcculw.enums as me
import ctypes as ct 

def chan_range(range_option):

    if range_option == 'bipolar_10':
        range_enum = me.ULRange.BIP10VOLTS
    elif range_option == 'unipolar_5':
        range_enum = me.ULRange.UNI5VOLTS

    return range_enum


def read_sample(board_num, channel, ai_range):

    float_data = mu.v_in(board_num, channel, ai_range)

    return float_data


def create_buffer(num_points):

    memhandle = mu.scaled_win_buf_alloc(num_points)

    ptr = ct.POINTER(ct.c_double)
    ctypes_array = ct.cast(memhandle, ptr)

    return memhandle, ctypes_array


def read_waveform(board_num, low_chan, high_chan,
                  num_points, rate, ai_range, 
                  memhandle, ctypes_array):   

    scan_options = me.ScanOptions.SCALEDATA

    mu.a_in_scan(board_num, low_chan, high_chan,
                 num_points, rate, ai_range, 
                 memhandle, scan_options)

    y = [ctypes_array[i] for i in range(num_points)]

    return y


def free_buffer(memhandle):

    mu.win_buf_free(memhandle)

    return


def config_digital_triggering(board_num, edge_option):

    if edge_option == 'Rising':
        trig_type = me.TrigType.TRIG_POS_EDGE
    else:
        trig_type = me.TrigType.TRIG_NEG_EDGE

    mu.set_trigger(board_num, trig_type, 0, 0)

    return


def read_waveform(board_num, low_chan, high_chan,
                  num_points, rate, ai_range, 
                  memhandle, ctypes_array):   

    enum_1 = me.ScanOptions.SCALEDATA
    enum_2 = me.ScanOptions.EXTTRIGGER

    scan_options = enum_1 | enum_2


    mu.a_in_scan(board_num, low_chan, high_chan,
                 num_points, rate, ai_range, 
                 memhandle, scan_options)

    y = [ctypes_array[i] for i in range(num_points)]

    return y


def write_sample(board_num, channel, ao_range, data_value):

    mu.v_out(board_num, channel, ao_range, data_value)

    return


def write_waveform(board_num, low_chan, high_chan,
                   num_points, rate, ao_range, memhandle):

    enum_1 = me.ScanOptions.BACKGROUND
    enum_2 = me.ScanOptions.CONTINUOUS
    enum_3 = me.ScanOptions.SCALEDATA


    scan_options = enum_1 | enum_2 | enum_3

    mu.a_out_scan(board_num, low_chan, high_chan,
                  num_points, rate, ao_range, memhandle,
                  scan_options)

    return


def stop_waveform(board_num):

    function_type = me.FunctionType.AOFUNCTION
    mu.stop_background(board_num, function_type)

    return


def config_do_port(board_num):

    port_type = me.DigitalPortType.AUXPORT
    direction = me.DigitalIODirection.OUT

    mu.d_config_port(board_num, port_type, direction)

    return

def write_do_port(board_num, data_value):

    port_type = me.DigitalPortType.AUXPORT

    mu.d_out(board_num, port_type, data_value)

    return


def clear_counter(board_num, counter_num):

    mu.c_clear(board_num, counter_num)

    return

def read_counter(board_num, counter_num):

    count = mu.c_in_32(board_num, counter_num)

    return count


